﻿Imports nwind
Imports System.IO
Imports System.Windows.Forms
Imports System.Linq.Dynamic
Imports System.Linq.Expressions

Namespace Dynamic
    Module Program

        Sub Main()
            ' 要使此示例能够运行，需要活动数据库服务器或 SqlExpress。
            ' 下面是与 Microsoft Visual Studio 2008 附带的 Data 示例项目的连接。
            Dim dpPath = Path.GetFullPath(Path.Combine(Application.StartupPath, "..\..\Data\NORTHWND.MDF"))
            Dim sqlServerInstance = ".\SQLEXPRESS"
            Dim connString = "AttachDBFileName='" & dpPath & "';Server='" & sqlServerInstance & "';user instance=true;Integrated Security=SSPI;"

            ' 下面是可按自己的目的修改的备用连接字符串。
            ' string connString = "server=test;database=northwind;user id=test;password=test";

            Dim db As New Northwind(connString)
            db.Log = Console.Out

            Dim query _
              = db.Customers.Where("City == @0 and Orders.Count >= @1", "London", 10). _
                OrderBy("CompanyName"). _
                Select("New(CompanyName as Name, Phone)")
            Console.WriteLine(query)
            Console.ReadLine()
        End Sub

    End Module
End Namespace
